/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapFrame;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedItemFrameBlockEntity
extends FramedBlockEntity {
    public static final int ROTATION_STEPS = 8;
    private static final int MAP_UPDATE_INTERVAL = 10;
    public static final String NBT_KEY_FRAMED_MAP = "framedblocks:framed";
    private final boolean glowing;
    private ItemStack heldItem = ItemStack.f_41583_;
    private int rotation = 0;
    private int mapTickOffset = 0;
    private long mapTickCount = 0L;

    public FramedItemFrameBlockEntity(BlockPos pos, BlockState state) {
        super(FBContent.BE_TYPE_FRAMED_ITEM_FRAME.get(), pos, state);
        this.glowing = this.getBlockType() == BlockType.FRAMED_GLOWING_ITEM_FRAME;
    }

    public void tickWithMap() {
        if (this.mapTickCount % 10L == 0L) {
            MapItemSavedData mapData;
            if (this.mapTickCount == 0L) {
                this.mapTickCount = this.mapTickOffset;
            }
            if ((mapData = MapItem.m_42853_((ItemStack)this.heldItem, (Level)this.f_58857_)) != null) {
                int mapId = Objects.requireNonNull(MapItem.m_151131_((ItemStack)this.heldItem));
                for (Player player : this.f_58857_.m_6907_()) {
                    mapData.m_77918_(player, this.heldItem);
                    Packet packet = mapData.m_164796_(mapId, player);
                    if (packet == null) continue;
                    ((ServerPlayer)player).f_8906_.m_9829_(packet);
                }
            }
        }
        ++this.mapTickCount;
    }

    public InteractionResult handleFrameInteraction(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.hasItem()) {
            if (!this.f_58857_.m_5776_()) {
                this.rotation = (this.rotation + 1) % 8;
                this.playSound(this.glowing ? SoundEvents.f_144158_ : SoundEvents.f_12017_);
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (!stack.m_41619_() && !this.hasItem()) {
            if (!this.f_58857_.m_5776_()) {
                this.setItem(stack);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_150109_().m_6596_();
                this.playSound(this.glowing ? SoundEvents.f_144154_ : SoundEvents.f_12013_);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void removeItem(Player player) {
        if (this.heldItem.m_41720_() instanceof MapItem && this.heldItem.m_41782_()) {
            this.heldItem.m_41783_().m_128473_(NBT_KEY_FRAMED_MAP);
            MapItemSavedData mapData = MapItem.m_42853_((ItemStack)this.heldItem, (Level)this.f_58857_);
            if (mapData instanceof MapMarkerRemover) {
                MapMarkerRemover remover = (MapMarkerRemover)mapData;
                remover.framedblocks$removeMapMarker(this.f_58858_);
            }
        }
        if (!player.m_7500_() && !player.m_150109_().m_36054_(this.heldItem)) {
            player.m_36176_(this.heldItem, false);
        }
        this.setItem(ItemStack.f_41583_);
        this.playSound(this.glowing ? SoundEvents.f_144157_ : SoundEvents.f_12016_);
    }

    private void setItem(ItemStack item) {
        if (item.m_41619_()) {
            this.heldItem = ItemStack.f_41583_;
        } else {
            this.heldItem = item.m_41777_();
            this.heldItem.m_41764_(1);
            if (this.heldItem.m_41720_() instanceof MapItem) {
                Direction dir = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
                CompoundTag tag = new CompoundTag();
                tag.m_128356_("pos", this.f_58858_.m_121878_());
                tag.m_128344_("y_rot", (byte)dir.m_122416_());
                this.heldItem.m_41784_().m_128365_(NBT_KEY_FRAMED_MAP, (Tag)tag);
            }
        }
        this.m_6596_();
        if (!this.changeMapStateIfNeeded()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean hasItem() {
        return !this.heldItem.m_41619_();
    }

    public ItemStack getItem() {
        return this.heldItem;
    }

    public ItemStack getCloneItem() {
        ItemStack stack = this.heldItem.m_41777_();
        if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(NBT_KEY_FRAMED_MAP);
        }
        return stack;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isGlowingFrame() {
        return this.glowing;
    }

    private boolean changeMapStateIfNeeded() {
        boolean mapState;
        boolean mapItem = !this.heldItem.m_41619_() && this.heldItem.m_41720_() instanceof MapItem;
        if (mapItem != (mapState = ((Boolean)this.m_58900_().m_61143_((Property)PropertyHolder.MAP_FRAME)).booleanValue())) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)PropertyHolder.MAP_FRAME, (Comparable)Boolean.valueOf(mapItem)));
            this.mapTickOffset = mapItem ? this.f_58857_.f_46441_.m_188503_(10) : 0;
            this.mapTickCount = this.mapTickOffset;
            return true;
        }
        return false;
    }

    private void playSound(SoundEvent sound) {
        this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public void addAdditionalDrops(List<ItemStack> drops, boolean dropCamo) {
        super.addAdditionalDrops(drops, dropCamo);
        if (!this.heldItem.m_41619_()) {
            drops.add(this.getCloneItem());
        }
    }

    private void readFromNetwork(CompoundTag tag) {
        this.heldItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
        this.rotation = tag.m_128445_("rotation");
    }

    private void writeToNetwork(CompoundTag tag) {
        tag.m_128365_("item", (Tag)this.heldItem.m_41739_(new CompoundTag()));
        tag.m_128344_("rotation", (byte)this.rotation);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag tag) {
        this.readFromNetwork(tag);
        return super.readFromDataPacket(tag);
    }

    @Override
    protected void writeToDataPacket(CompoundTag tag) {
        super.writeToDataPacket(tag);
        this.writeToNetwork(tag);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.readFromNetwork(tag);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.writeToNetwork(tag);
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.heldItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
        this.rotation = tag.m_128445_("rotation");
        this.mapTickOffset = tag.m_128451_("map_tick_offset");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("item", (Tag)this.heldItem.m_41739_(new CompoundTag()));
        tag.m_128344_("rotation", (byte)this.rotation);
        tag.m_128405_("map_tick_offset", this.mapTickOffset);
    }

    public static interface MapMarkerRemover {
        public void framedblocks$removeMapMarker(BlockPos var1);
    }

    public record FramedMap(BlockPos pos, int yRot) {
        public static FramedMap load(CompoundTag tag) {
            return new FramedMap(BlockPos.m_122022_((long)tag.m_128454_("pos")), tag.m_128451_("y_rot"));
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("pos", this.pos.m_121878_());
            tag.m_128405_("y_rot", this.yRot);
            return tag;
        }

        public static String makeFrameId(BlockPos pos) {
            return "framedblocks:" + MapFrame.m_77870_((BlockPos)pos);
        }
    }
}

